<?php

namespace Omnipay\TwoCheckout\Message;

use Omnipay\Common\Message\AbstractResponse;
use Omnipay\Common\Message\RedirectResponseInterface;

/**
 * 2Checkout Purchase Response
 */
class PurchaseResponse extends AbstractResponse implements RedirectResponseInterface
{
    protected $endpoint = 'https://www.2checkout.com/checkout/purchase';
    protected $testEndpoint = 'https://sandbox.2checkout.com/checkout/purchase';

    public function isSuccessful()
    {
        return false;
    }

    public function isRedirect()
    {
        return true;
    }

    public function getRedirectUrl()
    {
        $endpoint = $this->getRequest()->getTestMode() ? $this->testEndpoint : $this->endpoint;
        return $endpoint.'?'.http_build_query($this->data);
    }

    public function getRedirectMethod()
    {
        return 'GET';
    }

    public function getRedirectData()
    {
        return array();
    }
}
